<?php

namespace App\Http\Controllers;

use App\Models\MotorModel;
use Illuminate\Http\Request;

class EditController extends Controller
{
    public function updateStoreMotor(Request $request, $id_motor)
{
    // Validasi data input lainnya jika diperlukan

    $dataMotor = MotorModel::find($id_motor);
    $dataMotor->namaMotor = $request->input('namaMotor');
    $dataMotor->hargaMotor = $request->input('hargaMotor');
    $dataMotor->categoryMotor = $request->input('categoryMotor');
    $dataMotor->tipe = strtolower($request->input('tipeMotor'));
    $dataMotor->deskripsiWarna = json_encode($request->input('deskripsiWarna'));
    // Menyimpan banyak warna sebagai JSON string
    $dataMotor->deskripsi = json_encode($request->input('descMotor'));

    // Mengambil foto yang sudah ada sebelumnya
    $existingPhotos = $dataMotor->fotoMotor ? json_decode($dataMotor->fotoMotor, true) : [];

    $fotoNames = [];

    if ($request->hasFile('fotoMotor')) {
        // Menghapus foto lama dari direktori penyimpanan
        foreach ($existingPhotos as $photo) {
            $photoPath = public_path('uploads/allMotor/' . $photo);
            if (file_exists($photoPath)) {
                unlink($photoPath);
            }
        }

        // Mengunggah dan menyimpan foto baru
        foreach ($request->file('fotoMotor') as $file) {
            $extension = $file->getClientOriginalExtension();
            $fileName = time() . '_' . uniqid() . '.' . $extension;
            $file->move('uploads/allMotor/', $fileName);
            $fotoNames[] = $fileName;
        }
    } else {
        // Jika tidak ada file yang diunggah baru, gunakan foto yang sudah ada sebelumnya
        $fotoNames = $existingPhotos;
    }

    // Memastikan fotoMotor adalah array unik dan menyimpannya sebagai JSON
    $dataMotor->fotoMotor = json_encode(array_unique($fotoNames));
    $dataMotor->update();

    return redirect()->back()->with('status', 'Edit data motor berhasil!');
}

}
