<?php

namespace App\Http\Controllers;

use App\Models\ArtikelModel;
use App\Models\BestSellerModel;
use App\Models\CategoryModel;
use App\Models\DealerModel;
use App\Models\MotorModel;
use App\Models\SliderModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class HomeController extends Controller
{
    public function home(){
        $bgCategory = [
            'bg-classy.png',
            'bg-maxi.png',
            'bg-matic.png',
            'bg-sport.png',
            'bg-moped.png',
            'bg-offroad.png'
        ];
        $bestSeller = BestSellerModel::all();
        $dataHeader = SliderModel::all();
        $dataCategory = CategoryModel::all();
        $dataArtikel = ArtikelModel::all();
        return view('frontend.home.home',compact('bestSeller','dataHeader','dataCategory','bgCategory','dataArtikel'));
    }

    public function aboutus(){
        return view('frontend.aboutus.index');
    }
    public function booking(){
        return view('frontend.booking.index');
    }
    public function sky(){
        return view('frontend.booking.sky');
    }
    public function karir(){
        return view('frontend.karir.index');
    }
    public function karirDetail(){
        return view('frontend.karir.detail');
    }
    public function shop($id_category = null)
    {
    if (!empty($id_category)) {
        // Ambil data motor berdasarkan kategori yang dipilih
        $motors = DB::table('motor')
                        ->join('category', 'motor.categoryMotor', '=', 'category.id_category')
                        ->where('motor.categoryMotor', $id_category)
                        ->groupBy('motor.namaMotor')
                        ->get();

        foreach ($motors as $data) {
            $data->fotoNames = json_decode($data->fotoMotor);
            $data->warnaMotor = json_decode(($data->deskripsi));
        }
    } else {
        // Ambil semua data motor jika tidak ada kategori yang dipilih
        $motors = DB::table('motor')
                        ->join('category', 'motor.categoryMotor', '=', 'category.id_category')
                        ->groupBy('motor.namaMotor')
                        // ->groupBy('motor.id_motor', 'motor.namaMotor', 'motor.hargaMotor', 'motor.fotoMotor', 'motor.deskripsi')
                        ->get();

        foreach ($motors as $data) {
            $data->fotoNames = json_decode($data->fotoMotor);
            $data->warnaMotor = json_decode(($data->deskripsi));
        }
    }

    $groupedMotors = $motors->groupBy('namaMotor');
    //dd($groupedMotors);
    // Ambil semua kategori untuk filter
    $categories = CategoryModel::showNoEmpty();

    return view('frontend.shop.index', compact('groupedMotors','motors', 'categories', 'id_category'));
    }




    public function detailProduct($id_motor){
        $motors = DB::table('motor')
                    ->where('id_motor', $id_motor)
                    ->first();

           
            if ($motors) {
            // Mengambil dan mendecode properti secara langsung
            $motors->fotoNames = json_decode($motors->fotoMotor);
            $motors->warnaMotor = json_decode($motors->deskripsi);
            $motors->deskripsiWarna = json_decode($motors->deskripsiWarna);

            } else {
            // Penanganan jika tidak ada data yang ditemukan
            echo "No data found for id_motor: $id_motor";
            }
            
        $dataVarian = DB::table('motor')
                        ->where('namaMotor',$motors->namaMotor)
                        ->get();
        
       
        return view('frontend.shop.detail',compact('motors','dataVarian'));
    }

    public function dealer(){
        $dataDealer = DealerModel::all();
        return view('frontend.dealer.index',compact('dataDealer'));
    }

    public function news(){
        $dataArtikel = ArtikelModel::all();
        return view('frontend.news.index',compact('dataArtikel'));
    }
}
