<?php

namespace App\Http\Controllers;

use App\Models\ArtikelModel;
use Illuminate\Support\Facades\File;
use App\Models\BestSellerModel;
use App\Models\CabangModel;
use App\Models\CategoryModel;
use App\Models\MotorModel;
use App\Models\SliderModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MotorController extends Controller
{


    //BACKEND
    public function home(){
        return view('backend.dashboard.dashboard');
    }
    public function formBestSeller(){
        return view('backend.bestSeller.home');
    }
    public function formTambahMotor(){
        $category = CategoryModel::all();
        return view('backend.motorAll.home',compact('category'));
    }
    public function formDataCabang(){
        return view('backend.cabang.home');
    }
    public function formDataHeader(){
        return view('backend.slider.home');
    }
    public function formArtikel(){
        return view('backend.artikel.home');
    }

    public function dataBestSeller(){
        $bestSellerData = BestSellerModel::all();
        return view('backend.bestSeller.data',compact('bestSellerData'));
    }
    public function dataCabangDealer(){
        $dataCabang = CabangModel::all();
        return view('backend.cabang.data',compact('dataCabang'));
    }
    public function dataHeader(){
        $dataHeader = SliderModel::all();
        return view('backend.slider.data',compact('dataHeader'));
    }
    public function dataArtikel(){
        $dataArtikel = ArtikelModel::all();
        return view('backend.artikel.data',compact('dataArtikel'));
    }
    public function dataMotorAll(){
        $dataAllMotor = DB::table('motor')
                        ->join('category','motor.categoryMotor','=','category.id_category')
                        ->get();
                        foreach ($dataAllMotor as $data) {
                            $data->fotoNames = json_decode($data->fotoMotor);
                            $data->warnaMotor = json_decode(($data->deskripsi));
                        }
        return view('backend.motorAll.data',compact('dataAllMotor'));
    }

    public function deleteBestSeller($id_bestSeller){
        $bestSeller = BestSellerModel::find($id_bestSeller); // Menggunakan primary key 'id_dealer'

        // Hapus foto dealer dari folder uploads/cabang
        if ($bestSeller && File::exists(public_path('uploads/bestSeller/'.$bestSeller->fotoMotor))) {
            File::delete(public_path('uploads/bestSeller/'.$bestSeller->fotoMotor));
        }

        if ($bestSeller) {
            $bestSeller->delete();
            return redirect()->back()->with('status', 'Data Best Seller Berhasil Dihapus');
        } else {
            return redirect()->back()->with('error', 'Data tidak ditemukan.');
        }
    }

    public function deleteHeader($id_slider){
        $dataHeader = SliderModel::find($id_slider); // Menggunakan primary key 'id_dealer'

        // Hapus foto dealer dari folder uploads/cabang
        if ($dataHeader && File::exists(public_path('uploads/slider/'.$dataHeader->name))) {
            File::delete(public_path('uploads/slider/'.$dataHeader->name));
        }

        if ($dataHeader) {
            $dataHeader->delete();
            return redirect()->back()->with('status', 'Data Best Seller Berhasil Dihapus');
        } else {
            return redirect()->back()->with('error', 'Data tidak ditemukan.');
        }
    }


    public function hapusMotor($id_motor){
        $motor = MotorModel::find($id_motor);
         // Hapus foto motor dari folder uploads/motor
         if ($motor && File::exists(public_path('uploads/allMotor/'.$motor->fotoMotor))) {
            File::delete(public_path('uploads/allMotor/'.$motor->fotoMotor));
        }

        if ($motor) {
            $motor->delete();
            return redirect()->back()->with('status', 'Data Motor Berhasil Dihapus');
        } else {
            return redirect()->back()->with('error', 'Data tidak ditemukan.');
        }
    }


    public function deleteCabang($id_dealer)
    {
        $cabang = CabangModel::find($id_dealer); // Menggunakan primary key 'id_dealer'

        // Hapus foto dealer dari folder uploads/cabang
        if ($cabang && File::exists(public_path('uploads/cabang/'.$cabang->foto_dealer))) {
            File::delete(public_path('uploads/cabang/'.$cabang->foto_dealer));
        }

        if ($cabang) {
            $cabang->delete();
            return redirect()->back()->with('status', 'Data Cabang Berhasil Dihapus');
        } else {
            return redirect()->back()->with('error', 'Data tidak ditemukan.');
        }
    }

    public function storeBestSeller(Request $request){
        $bestSeller = new BestSellerModel;
        $bestSeller->namaMotor = $request->input('namaMotor');
        $bestSeller->hargaMotor = $request->input('hargaMotor');
        if($request->hasFile('fotoMotor'))
            {
                $file = $request->file('fotoMotor');
                $extention = $file->getClientOriginalExtension();
                $fileName = time().'.'.$extention;
                $file->move('uploads/bestSeller/',$fileName);
                $bestSeller->fotoMotor = $fileName;
            }
        $bestSeller->save();
        return redirect()->back()->with('status','Tambah data best seller berhasil !');
    }

    public function storeHeader(Request $request){
        $dataHeader = new SliderModel();
        if($request->hasFile('fotoHeader'))
            {
                $file = $request->file('fotoHeader');
                $extention = $file->getClientOriginalExtension();
                $fileName = time().'.'.$extention;
                $file->move('uploads/slider/',$fileName);
                $dataHeader->name = $fileName;
            }
        $dataHeader->save();
        return redirect()->back()->with('status','Tambah data motor berhasil !');

    }

    public function storeArtikel(Request $request){
        $bestSeller = new ArtikelModel();
        $bestSeller->judul = $request->input('judulArtikel');
        $bestSeller->isi = $request->input('isiArtikel');
        if($request->hasFile('fotoArtikel'))
            {
                $file = $request->file('fotoArtikel');
                $extention = $file->getClientOriginalExtension();
                $fileName = time().'.'.$extention;
                $file->move('uploads/artikel/',$fileName);
                $bestSeller->foto_artikel = $fileName;
            }
        $bestSeller->save();
        return redirect()->back()->with('status','Tambah data best seller berhasil !');
    }

    public function storeDataMotor(Request $request){
        $dataMotor = new MotorModel();
        $dataMotor->namaMotor = $request->input('namaMotor');
        $dataMotor->hargaMotor = $request->input('hargaMotor');
        $dataMotor->categoryMotor = $request->input('categoryMotor');
        $dataMotor->tipe = strtolower($request->input('tipeMotor'));
        $dataMotor->deskripsiWarna = json_encode($request->input('deskripsiWarna'));
        // Menyimpan banyak warna sebagai JSON string
        $dataMotor->deskripsi = json_encode($request->input('descMotor'));
    
        // Menyimpan banyak foto
        $fotoNames = [];
        if($request->hasFile('fotoMotor')) {
            foreach ($request->file('fotoMotor') as $file) {
                $extention = $file->getClientOriginalExtension();
                $fileName = time() . '_' . uniqid() . '.' . $extention;
                $file->move('uploads/allMotor/', $fileName);
                $fotoNames[] = $fileName;
            }
            $dataMotor->fotoMotor = json_encode($fotoNames);
        }
    
        //dd($dataMotor);
        $dataMotor->save();
        return redirect()->back()->with('status', 'Tambah data motor berhasil!');
    }
    
    public function storeCabang(Request $request){
        $dataCabang = new CabangModel();
        $dataCabang->nama_dealer = $request->input('namaDealer');
        $dataCabang->alamat_dealer = $request->input('alamatDealer');
        $dataCabang->url_gmaps = $request->input('urlGmaps');
        $dataCabang->no_wa = $request->input('noWa');
        if($request->hasFile('fotoDealer'))
            {
                $file = $request->file('fotoDealer');
                $extention = $file->getClientOriginalExtension();
                $fileName = time().'.'.$extention;
                $file->move('uploads/cabang/',$fileName);
                $dataCabang->foto_dealer = $fileName;
            }
        $dataCabang->save();
        return redirect()->back()->with('status','Tambah data cabang berhasil !');
    }



    //EDIT
    public function editArtikel($id_artikel){
        $artikel = ArtikelModel::find($id_artikel);
        return view('backend.artikel.edit',compact('artikel'));
    }

    public function ubahMotor($id_motor){
        $motor = MotorModel::find($id_motor);
        $category = CategoryModel::all();
        $motor->deskripsiWarna = json_decode($motor->deskripsiWarna);
        $motor->deskripsi = json_decode($motor->deskripsi);
        $motor->fotoArray = json_decode($motor->fotoMotor);
        return view('backend.motorAll.edit',compact('motor','category'));
    }

    


}
