<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CategoryModel extends Model
{
    use HasFactory;
    protected $table = 'category';
    protected $guarded = ['id_category'];
    public function motors()
    {
        return $this->hasMany(MotorModel::class, 'categoryMotor', 'id_category');
    }
    public function getNameAttribute($value)
    {
        return ucwords($value);
    }
    public static function showNoEmpty(){
        return self::whereRaw('(SELECT count(*) as counter FROM motor WHERE motor.categoryMotor = category.id_category) > 0 ')->get();
    }
}
