@extends('backend.layouts.template')
@section('title','Data Cabang')
@section('content')
<h4>Data Cabang Dealer</h4>
@if (session('status'))
<h6 class="alert alert-success">{{session('status')}}</h6>
@endif
<div class="table-responsive col-md-12">
    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
        <thead>
            <tr>
                <th>Nama Dealer</th>
                <th>Alamat Dealer</th>
                <th>Foto Dealer</th>
                <th>Action</th>
            </tr>
        </thead>
        
        <tbody>
            @foreach($dataCabang as $data)
                <tr>
                    <td><b>{{ $data->nama_dealer }}</td>
                    <td><b>{{ $data->alamat_dealer }}</td>
                    <td>
                        <img src="{{asset('uploads/cabang/'.$data->foto_dealer)}}" width="70px" height="70px" alt="Image">
                    </td>
                    <td>
                        <a href="{{url ('deleteCabang/'.$data->id_dealer)}}" class="btn btn-danger">Hapus Data</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection