@extends('backend.layouts.template')
@section('title','Edit Data Motor')
@section('content')
<h4>Form Tambah Motor</h4>
    @if (session('status'))
        <h6 class="alert alert-success">{{session('status')}}</h6>
    @endif
    <div class="card col-md-8">
        <form action="{{url('updateMotor/'.$motor->id_motor)}}" method="POST" enctype="multipart/form-data" id="formTambahMotor">
            @csrf
            @method('PUT')
            <label class="mt-4">Nama Motor</label>
            <input type="text" name="namaMotor" value="{{$motor->namaMotor}}" class="form-control" required><br>
            <label class="mt-2">Harga Motor</label>
            <input type="number" name="hargaMotor" value="{{$motor->hargaMotor}}" class="form-control" required><br>
            <label class="mt-2">Tipe Motor</label>
            <input type="text" name="tipeMotor"  value="{{$motor->tipe}}"class="form-control" placeholder="Contoh :Connected" required><br>
            <label class="mt-2">Kategori Motor</label>
            <select name="categoryMotor" class="form-control form-control-lg mb-2" required>
                @foreach ($category as $data)
                <option value="{{$data->id_category}}" selected>{{$data->name}}</option>
                @endforeach
            </select>
            <div class="container mt-4">
                <div id="dynamic-fields-container">
                    @foreach ($motor->deskripsiWarna as $index => $warna)
                        <div id="dynamic-field-{{ $index + 1 }}" class="form-group dynamic-field">
                            <label class="mt-2">Warna Motor (pilih yang paling mendekati)</label>
                            <select name="descMotor[]" class="form-control">
                                <option value="red">Merah</option>
                                <option value="yellow">Kuning</option>
                                <option value="green">Hijau</option>
                                <option value="orange">Orange</option>
                                <option value="brown">Brown</option>
                                <option value="blue">Biru</option>
                                <option value="black">Hitam</option>
                                <option value="#84d2c3">Mint</option>
                                <option value=#ecd78e">Kuning Gelap</option>
                                <option value="#2c2324">Magma Black</option>
                                <option value="white">Putih</option>
                                <option value="grey">Abu-Abu</option>
                                <option value="pink">Pink</option>
                                <option value="cyan">Cyan</option>
                                <option value="olive">Olive</option>
                                <option value="#b0d4ea">Dull Blue</option>
                            </select>
                            
                            <label class="mt-2">Deskripsi Warna</label>
                            <input type="text" name="deskripsiWarna[]" class="form-control" value="{{ $warna }}" required>
            
                            <label class="mt-2">Foto Motor</label>
                            <input type="file" name="fotoMotor[]" class="form-control-file">
                            <small class="form-text text-muted">Biarkan kosong jika tidak ingin mengubah foto.</small>
                            <!-- Menampilkan foto motor yang sesuai dengan indeks warna -->
                            <img src="{{ asset('uploads/allMotor/' . $motor->fotoArray[$index]) }}" width="100px" height="100px" alt="Foto Motor">
                        </div>
                    @endforeach
                </div>
            
                <button class="btn btn-success mt-2" type="button" id="add-button">
                    <i class="glyphicon glyphicon-plus"></i> Tambah Foto
                </button>
            </div>
            

            <div class="d-flex justify-content-end">
                <button class="btn btn-info mt-2 mb-4" type="submit" id="submit-button">Simpan Data</button>
            </div>
        </form>
    </div>

    <script>
        document.getElementById('submit-button').addEventListener('click', function(event) {
            // Munculkan dialog konfirmasi
            if (!window.confirm('Periksa Kembali Warna Motor Apakah Sudah Benar ?')) {
                // Prevent default action (submit form) jika pengguna memilih Cancel
                event.preventDefault();
            }
        });
    </script>
@endsection

