@extends('backend.layouts.template')
@section('title','Tambah Data Motor')
@section('content')
<h4>Form Tambah Motor</h4>
    @if (session('status'))
        <h6 class="alert alert-success">{{session('status')}}</h6>
    @endif
    <div class="card col-md-8">
        <form action="{{url ('tambahDataMotor')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <label class="mt-4">Nama Motor</label>
            <input type="text" name="namaMotor" class="form-control" required><br>
            <label class="mt-2">Harga Motor</label>
            <input type="number" name="hargaMotor" class="form-control" required><br>
            <label class="mt-2">Tipe Motor</label>
            <input type="text" name="tipeMotor" class="form-control" placeholder="Contoh :Connected" required><br>
            <label class="mt-2">Kategori Motor</label>
            <select name="categoryMotor" class="form-control form-control-lg mb-2" required>
                @foreach ($category as $data)
                <option value="{{$data->id_category}}">{{$data->name}}</option>
                @endforeach
            </select>

            <div class="container mt-4">
                <div id="dynamic-fields-container">
                    <div id="dynamic-field-1" class="form-group dynamic-field">
                        <label class="mt-2">Warna Motor (pilih yang paling mendekati)</label>
                        <select name="descMotor[]" class="form-control">
                            <option value="red">Merah</option>
                            <option value="yellow">Kuning</option>
                            <option value="green">Hijau</option>
                            <option value="orange">Orange</option>
                            <option value="brown">Brown</option>
                            <option value="blue">Biru</option>
                            <option value="black">Hitam</option>
                            <option value="#84d2c3">Mint</option>
                            <option value=#ecd78e">Kuning Gelap</option>
                            <option value="#2c2324">Magma Black</option>
                            <option value="white">Putih</option>
                            <option value="grey">Abu-Abu</option>
                            <option value="pink">Pink</option>
                            <option value="cyan">Cyan</option>
                            <option value="olive">Olive</option>
                            <option value="#b0d4ea">Dull Blue</option>
                        </select>
                        <label class="mt-2">Deskripsi Warna</label>
                        <input type="text" name="deskripsiWarna[]" class="form-control" required>
                        <label class="mt-2">Foto Motor</label>
                        <input type="file" name="fotoMotor[]" class="form-control" multiple required>
                        <button class="btn btn-danger remove-button mt-2" type="button">
                            Hapus
                        </button>
                    </div>
                </div>
                <button class="btn btn-success mt-2" type="button" id="add-button">
                    <i class="glyphicon glyphicon-plus"></i> Tambah Foto
                </button>
            </div>

            <div class="d-flex justify-content-end">
                <button class="btn btn-info mt-2 mb-4" type="submit">Simpan Data</button>
            </div>
        </form>
    </div>

@endsection

