@extends('frontend.layouts.template')
@section('content')
<div id="carouselExampleIndicators" class="carousel slide mt-100" data-ride="carousel">
    <ol class="carousel-indicators">
        @foreach ($dataHeader as $index => $data)
            <li data-target="#carouselExampleIndicators" data-slide-to="{{ $index }}" class="{{ $index == 0 ? 'active' : '' }}"></li>
        @endforeach
    </ol>
    <div class="carousel-inner">
        @foreach ($dataHeader as $index => $data)
            <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                <img class="d-block w-100" src="{{ asset('uploads/slider/'.$data->name) }}" alt="Slide {{ $index + 1 }}">
                <div class="carousel-caption d-none d-md-block">
                    <!--<h5>{{ $data->name }}</h5>
                    <p>{{ $data->description }}</p>-->
                </div>
            </div>
        @endforeach
    </div>
    <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="sr-only">Previous</span>
    </a>
    <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="sr-only">Next</span>
    </a>
</div>





<div class="product-section mt-150">
    <div class="container">
      <div class="row">
        <div class="col-lg-8 offset-lg-2 text-center">
            <div class="section-title">    
                <h3><span class="blue-text " style="color:#0693e3;">SELAMAT DATANG DI PUTERA GROUP</span></h3>
            </div>
        </div>
            <div class="col-lg-12">
                <h4 class="text-center">
                    Lihat promo terbaru di putera group – Putera Group ialah Super Dealer Yamaha terbesar di Jabodetabek dan Banten, kami menawarkan kredit motor baru dengan harga terbaik dan melayani servis motor Yamaha serta penggantian spare part genuine Yamaha.
                </h4>
            </div>
        </div>
    </div>
</div>



<!--Start Category-->
<div class="product-section mt-100">
    <div class="container">
      <div class="row">
        <div class="col-lg-8 offset-lg-2 text-center">
            <div class="section-title">    
                <h3><span class="blue-text">Produk Kategori</span></h3>
            </div>
        </div>
            <div class="col-lg-12">
                <div class="owl-carousel owl-theme">
                    @foreach ($dataCategory as $data)
                    <div class="item">
                        <div class=" text-center">
                            <a href="{{url('shop')}}">
                            <div class="ml-2">
                                <img src="{{ asset('frontend/assets/img/icon-category/' . $bgCategory[$loop->index]) }}" width="250px" height="250px" alt="Image">
                            </div>
                            </a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
<!--End Category-->

<!-- Best Seller -->
<div class="product-section mt-100 mb-25">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 offset-lg-2 text-center">
                <div class="section-title">    
                    <h3><span class="blue-text">Produk</span> Terlaris</h3>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="owl-carousel owl-theme">
                    @foreach ($bestSeller as $data)
                    <!--<a href="{{url ('detailProduct/'.$data->id_bestSeller)}}">-->
                    <div class="item">
                        <div class="single-product-item text-center">
                            <div class="product-image">
                                    <img src="{{asset('uploads/bestSeller/'.$data->fotoMotor)}}" width="100px" height="200px" alt="Image">
                            </div>
                            <h5>{{$data->namaMotor}}</h5>
                            <h6>Rp {{ number_format($data->hargaMotor, 0, ',', '.') }}</h6>
                            <!--<a href="cart.html" class="cart-btn"><i class="fas fa-shopping-cart"></i> Add to Cart</a>-->
                        </div>
                    </div>
                   <!-- </a> -->
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
<!-- end Best Seller -->





	<div class="product-section mt-50 mb-50">
		<div class="container">
			<div class="row">
				<div class="col-lg-8 offset-lg-2 text-center">
					<div class="section-title">	
						<h3><span class="blue-text">Temukan Sepeda Motor Favoritmu Di Marketplace Kami</span></h3>
					</div>
				</div>
			</div>

			<div class="row justify-content-center">
                <div class="col-lg-4 col-md-6 text-center">
					<div class="">
                        <a href="https://www.tokopedia.com/yamaha-putera">
						<div class="product-image">
                            <img src="{{asset('frontend')}}/assets/img/tokopedia-logo.png" width="50px" height="100px">
						</div>
                        </a>
					</div>
				</div>
                <div class="col-lg-4 col-md-6 text-center">
					<div class="">
                        <a href="https://www.blibli.com/merchant/yamaha-putera-group/YAP-13694?pickupPointCode=ALL_LOCATIONS">
						<div class="product-image">
                            <img src="{{asset('frontend')}}/assets/img/blibli-logo.png" width="50px" height="100px">
						</div>
                        </a>
					</div>
				</div>

				
			</div>

		</div>
	</div>
@endsection