@extends('frontend.layouts.template')
@section('title','Detail')
@section('content')
    <!-- single product -->
	<div class="single-product mt-150 mb-150">
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-md-12 text-center mb-2">
                    <h3>{{ ucwords($motors->tipe) }}</h3>
					<div class="row justify-content-center">
						@if ($motors && is_array($motors->fotoNames))
                            <div id="imageContainer">
                                @foreach ($motors->fotoNames as $index => $fotoName)
                                    <img class="ml-2 mr-2 mt-2" id="image-{{ $index }}" 
                                         src="{{ asset('uploads/allMotor/' . $fotoName) }}" 
                                         width="350px" 
                                         height="300px" 
                                         alt="Image" 
                                         style="display: none;">
                                @endforeach
                            </div>
						@else
							<p>No images available.</p>
						@endif
					</div>
				</div>
				<div class="row ml-2">
                    <div class="single-product-content">
                        <div class="row ml-2">
                        <ul class="product-share">
                            @foreach ($dataVarian as $data)
                                <li><a href="{{url ('detailProduct/'.$data->id_motor)}}" class="btn btn-secondary mt-2"><b style="color:white;">{{$data->tipe}}</b></a></li>
                            @endforeach
                        </ul>
                        </div>
                        <div class="row ml-2">
                            @if ($motors && is_array($motors->deskripsiWarna) && is_array($motors->warnaMotor))
                                @foreach ($motors->deskripsiWarna as $index => $deskripsi)
                                    @if (isset($motors->warnaMotor[$index]))
                                        <div class="color-box m-2"
                                             data-index="{{ $index }}"
                                             style="background-color: {{ $motors->warnaMotor[$index] }}; height: 50px; width: 50px; cursor: pointer; border: 2px solid grey;">
                                        </div>
                                    @endif
                                @endforeach
                            @endif
                        </div>
                        
                        <div id="color-description-container">
                            @if ($motors && is_array($motors->deskripsiWarna))
                                @foreach ($motors->deskripsiWarna as $index => $deskripsi)
                                    <div id="desc-{{ $index }}" class="color-description ml-4 " style="display: none;">
                                        <b>{{ $deskripsi }}</b>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                        
                        <p class="single-product-pricing ml-2">
                            Rp {{ number_format($motors->hargaMotor, 0, ',', '.') }}
                            <span>*OTR JAKARTA</span>
                        </p>
                        
                        
                    </div>
                </div>
                
			</div>
		</div>
	</div>
	<!-- end single product -->

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const colorBoxes = document.querySelectorAll('.color-box');
            const images = document.querySelectorAll('#imageContainer img');
            const descriptions = document.querySelectorAll('.color-description');

            colorBoxes.forEach(box => {
                box.addEventListener('click', function () {
                    // Hide all images
                    images.forEach(img => {
                        img.style.display = 'none';
                    });

                    // Hide all descriptions
                    descriptions.forEach(desc => {
                        desc.style.display = 'none';
                    });

                    // Get index from data-index attribute
                    const index = this.getAttribute('data-index');
                    // Show the image with the corresponding index
                    const imageToShow = document.getElementById('image-' + index);
                    if (imageToShow) {
                        imageToShow.style.display = 'block';
                    }

                    // Show the description with the corresponding index
                    const descToShow = document.getElementById('desc-' + index);
                    if (descToShow) {
                        descToShow.style.display = 'block';
                    }
                });
            });

            // Optionally, you can show the first image and description by default
            if (images.length > 0) {
                images[0].style.display = 'block';
            }
            if (descriptions.length > 0) {
                descriptions[0].style.display = 'block';
            }
        });
    </script>
@endsection
