<!-- resources/views/frontend/shop/index.blade.php -->


<?php $__env->startSection('title', 'Shop'); ?>
<?php $__env->startSection('content'); ?>

<!-- breadcrumb-section -->
<div class="breadcrumb-section breadcrumb-bgshop mt-100">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 offset-lg-2 text-center">
                <div class="breadcrumb-text">
                    <p>Temukan Sepeda Motor Favoritmu di Marketplace Kami</p>
                    <div class="row justify-content-center">
                        <div class = "col-md-4 mt-4">
                            <a href="https://www.tokopedia.com/yamaha-putera">
                                <img src="<?php echo e(asset('frontend')); ?>/assets/img/tokopedia-logo.png" width="225px" height="100px">
                            </a>
                        </div>
                        <div class = "col-md-4 mt-4">
                            <a href="https://www.blibli.com/merchant/yamaha-putera-group/YAP-13694?pickupPointCode=ALL_LOCATIONS">
                                <img src="<?php echo e(asset('frontend')); ?>/assets/img/blibli-logo.png" width="225px" height="100px">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- end breadcrumb section -->

<div class="product-section mt-150 mb-150">
    <div class="container">

        <div class="row">
            <div class="col-md-12">
                <div class="product-filters">
                    <ul>
                        <li class="<?php echo e(is_null($id_category) ? 'active' : ''); ?>" data-filter="*" data-id="">Semua Kategori</li>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="listcategories <?php echo e($category->id_category == $id_category ? 'active' : ''); ?>" data-filter=".category-<?php echo e($category->id_category); ?>" data-id="<?php echo e($category->id_category); ?>">
                            
                            <?php echo e(ucwords(strtolower($category->name))); ?>

                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                
            </div>
        </div>
        

        <div id='productView'>
            <div class="row product-lists">
                <?php $__currentLoopData = $motors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $motor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6 text-center category-<?php echo e($motor->categoryMotor); ?>">
                    <div class="single-product-item">
                        <div class="product-image">
                            <a href="<?php echo e(url('detailProduct/'.$motor->id_motor)); ?>">
                                <?php if(is_array($motor->fotoNames) && !empty($motor->fotoNames)): ?>
                                    <img src="<?php echo e(asset('uploads/allMotor/' . $motor->fotoNames[0])); ?>" width="200px" height="200px" alt="Image">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('uploads/allMotor/default.jpg')); ?>" width="200px" height="200px" alt="Image">
                                <?php endif; ?>
                            </a>
                        </div>
                        <h3><?php echo e($motor->namaMotor); ?></h3>
                        <p class="product-price">Rp <?php echo e(number_format($motor->hargaMotor, 0, ',', '.')); ?> </p>
                        <a href="<?php echo e(url('detailProduct/'.$motor->id_motor)); ?>" class="cart-btn"><i class="fas fa-bars"></i> Detail</a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
            </div>
        </div>

        

       <!-- <div class="row">
            <div class="col-lg-12 text-center">
                <div class="pagination-wrap">
                    <ul>
                        <li><a href="#">Prev</a></li>
                        <li><a href="#">1</a></li>
                        <li><a class="active" href="#">2</a></li>
                        <li><a href="#">3</a></li>
                        <li><a href="#">Next</a></li>
                    </ul>
                </div>
            </div>
        </div>-->
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
    <script>
        // $(".listcategories").click(function(){
        //     var id = $(this).data('id')
        //     $.get("<?php echo e(url('shopRender')); ?>/"+id, function( data ) {
        //         $( "#productView" ).html( data );
        //     });
        // });   
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\puteraMarket\resources\views/frontend/shop/index.blade.php ENDPATH**/ ?>