
<?php $__env->startSection('title','Edit Data Motor'); ?>
<?php $__env->startSection('content'); ?>
<h4>Form Tambah Motor</h4>
    <?php if(session('status')): ?>
        <h6 class="alert alert-success"><?php echo e(session('status')); ?></h6>
    <?php endif; ?>
    <div class="card col-md-8">
        <form action="<?php echo e(url('updateMotor/'.$motor->id_motor)); ?>" method="POST" enctype="multipart/form-data" id="formTambahMotor">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <label class="mt-4">Nama Motor</label>
            <input type="text" name="namaMotor" value="<?php echo e($motor->namaMotor); ?>" class="form-control" required><br>
            <label class="mt-2">Harga Motor</label>
            <input type="number" name="hargaMotor" value="<?php echo e($motor->hargaMotor); ?>" class="form-control" required><br>
            <label class="mt-2">Tipe Motor</label>
            <input type="text" name="tipeMotor"  value="<?php echo e($motor->tipe); ?>"class="form-control" placeholder="Contoh :Connected" required><br>
            <label class="mt-2">Kategori Motor</label>
            <select name="categoryMotor" class="form-control form-control-lg mb-2" required>
                <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($data->id_category); ?>" selected><?php echo e($data->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <div class="container mt-4">
                <div id="dynamic-fields-container">
                    <?php $__currentLoopData = $motor->deskripsiWarna; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $warna): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div id="dynamic-field-<?php echo e($index + 1); ?>" class="form-group dynamic-field">
                            <label class="mt-2">Warna Motor (pilih yang paling mendekati)</label>
                            <select name="descMotor[]" class="form-control">
                                <option value="red">Merah</option>
                                <option value="yellow">Kuning</option>
                                <option value="green">Hijau</option>
                                <option value="orange">Orange</option>
                                <option value="brown">Brown</option>
                                <option value="blue">Biru</option>
                                <option value="black">Hitam</option>
                                <option value="#84d2c3">Mint</option>
                                <option value=#ecd78e">Kuning Gelap</option>
                                <option value="#2c2324">Magma Black</option>
                                <option value="white">Putih</option>
                                <option value="grey">Abu-Abu</option>
                                <option value="pink">Pink</option>
                                <option value="cyan">Cyan</option>
                                <option value="olive">Olive</option>
                                <option value="#b0d4ea">Dull Blue</option>
                            </select>
                            
                            <label class="mt-2">Deskripsi Warna</label>
                            <input type="text" name="deskripsiWarna[]" class="form-control" value="<?php echo e($warna); ?>" required>
            
                            <label class="mt-2">Foto Motor</label>
                            <input type="file" name="fotoMotor[]" class="form-control-file">
                            <small class="form-text text-muted">Biarkan kosong jika tidak ingin mengubah foto.</small>
                            <!-- Menampilkan foto motor yang sesuai dengan indeks warna -->
                            <img src="<?php echo e(asset('uploads/allMotor/' . $motor->fotoArray[$index])); ?>" width="100px" height="100px" alt="Foto Motor">
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            
                <button class="btn btn-success mt-2" type="button" id="add-button">
                    <i class="glyphicon glyphicon-plus"></i> Tambah Foto
                </button>
            </div>
            

            <div class="d-flex justify-content-end">
                <button class="btn btn-info mt-2 mb-4" type="submit" id="submit-button">Simpan Data</button>
            </div>
        </form>
    </div>

    <script>
        document.getElementById('submit-button').addEventListener('click', function(event) {
            // Munculkan dialog konfirmasi
            if (!window.confirm('Periksa Kembali Warna Motor Apakah Sudah Benar ?')) {
                // Prevent default action (submit form) jika pengguna memilih Cancel
                event.preventDefault();
            }
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.layouts.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\puteraMarket\resources\views/backend/motorAll/edit.blade.php ENDPATH**/ ?>